# Graphics credit:
#  https://opengameart.org/content/tiny-zelder-clone-topdown-pack

class_name Player extends CharacterBody2D

@onready var animated_sprite = $PlayerAnimatedSprite2D

@export var speed = 400.0

var is_idle = false
var last_active_animation_direction = "down"

func _process(_delta: float) -> void:
	var direction = Vector2(
		Input.get_axis("player_left", "player_right"),
		Input.get_axis("player_up", "player_down")
	).normalized()
	var current_idle = direction.length_squared() < 0.01

	var animation_direction = last_active_animation_direction
	if current_idle != is_idle:
		if current_idle:
			animated_sprite.play("idle_" + animation_direction)

	if not current_idle:
		var horizontal = false
		var horizontal_direction = ""
		if abs(direction.x) > 0.1:
			horizontal = true
			if direction.x < 0:
				horizontal_direction = "left"
			else:
				horizontal_direction = "right"
		var vertical = false
		var vertical_direction = ""
		if abs(direction.y) > 0.1:
			vertical = true
			if direction.y < 0:
				vertical_direction = "up"
			else:
				vertical_direction = "down"
		animation_direction = vertical_direction if vertical else horizontal_direction
		if vertical and horizontal:
			animation_direction += "_" + horizontal_direction

	if last_active_animation_direction != animation_direction:
		last_active_animation_direction = animation_direction
		animated_sprite.play("walk_" + animation_direction)

	is_idle = current_idle

	velocity = direction * speed

func _physics_process(_delta: float) -> void:
	move_and_slide()
