extends Node2D

@onready var player_camera: Camera2D = $Player/Camera2D
@onready var environment_tile_map: TileMapLayer = $Environment :
	set(new_tile_map):
		environment_tile_map = new_tile_map
		if player_camera:
			_set_player_camera_limits()

func _ready() -> void:
	_set_player_camera_limits()

func _set_player_camera_limits() -> void:
	var rect = environment_tile_map.get_used_rect()
	var quad_size = environment_tile_map.rendering_quadrant_size
	var top_left = rect.position * quad_size
	var bottom_right = rect.end * quad_size
	if top_left == bottom_right:
		return
	print("set player limits: ", top_left, " | ", bottom_right)
	player_camera.limit_left = top_left.x
	player_camera.limit_top = top_left.y
	player_camera.limit_right = bottom_right.x
	player_camera.limit_bottom = bottom_right.y
